<?php
function kworks_ai_load_scripts() {
    wp_enqueue_script('jquery');
    wp_enqueue_script('jquery-ui-core');
    wp_enqueue_script('jquery-ui-tooltip');
}
add_action('admin_enqueue_scripts', 'kworks_ai_load_scripts');

function kworks_ai_admin_enqueue_scripts($hook_suffix) {

    wp_enqueue_script( 'jquery-ui', 'https://code.jquery.com/ui/1.13.2/jquery-ui.min.js', array('jquery'), '1.13.2', true );

    wp_enqueue_script('admin-js', plugins_url( 'js/admin-kworks-ai.min.js', __FILE__ ), ['jquery', 'wp-i18n'], '0.1.0', true);
    wp_set_script_translations( 'admin-js', 'kworks-ai', plugin_dir_path( __FILE__ ) . 'languages/js/' );

    wp_localize_script('admin-js', 'kworks_ai_ajax', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );

}
add_action( 'admin_enqueue_scripts', 'kworks_ai_admin_enqueue_scripts' );
function kworks_ai_admin_enqueue_styles() {
    wp_enqueue_style('jquery-ui-tooltip', 'https://code.jquery.com/ui/1.13.2/themes/smoothness/jquery-ui.css', array(), '1.13.2');

    wp_enqueue_style( 'kworks-ai-admin-styles', plugin_dir_url( __FILE__ ) . 'css/admin-kworks-ai.min.css', array(), '0.1.0' );
}
add_action( 'admin_enqueue_scripts', 'kworks_ai_admin_enqueue_styles' );

function kworks_ai_enqueue_scripts() {
    wp_enqueue_script( 'kworks-ai-script', plugins_url( 'js/kworks-ai.min.js', __FILE__ ), array( 'jquery' ), '0.1.0', true );
    wp_localize_script( 'kworks-ai-script', 'kworks_ai_ajax', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
}
add_action( 'wp_enqueue_scripts', 'kworks_ai_enqueue_scripts' );
