<?php
/*
Plugin Name: k.works AI
Description: Real-time display of response messages from ChatGPT.
Text Domain: kworks-ai
Domain Path: /languages
Contributors: kworks
Donate link: https://kworks.llc/donate
Author: kworks
Author URI: https://kworks.llc
Tags: ChatGPT, wordpress ai plugin, api connector, html element display
Requires at least: 6.0
Tested up to: 6.2
Version: 0.1.0
Requires PHP: 5.6
License: License: GPLv3 or later
License URL: https://www.gnu.org/licenses/gpl-3.0.html
*/


require_once(plugin_dir_path( __FILE__ )."scripts.php");

add_action('init', function () {
    nocache_headers();
    load_plugin_textdomain('kworks-ai', false, dirname(plugin_basename(__FILE__)) . '/languages');

});

function kworks_ai_ajax_function_init() {

    $config = get_option('kworks_ai_config');

    $len = is_array($config) ? count($config) : 0;
    $block = [];
    $class_name = [];
    $send = [];

    for ($i = 0; $i <= $len; $i++) {
        if(isset($config[$i]['block']) && $config[$i]['block']==='1') {
            $block[] = $i+1;
            $class_name[] = $config[$i]['class_name'];
        }
    }
    $send['block'] = $block;
    $send['class_name'] = $class_name;

    wp_send_json(json_encode($send));

}
function kworks_ai_ajax_function() {

    $api = get_option('kworks_ai_api');
    $config = get_option('kworks_ai_config');
    $configCount = is_array($config) ? count($config) : 0;
    $tools_action = isset($_POST['tools_action']) ? $_POST['tools_action'] : "";

    switch ($tools_action) {

        case "add":
            $block = isset($_POST['block']) ? (int)$_POST['block'] : 0;
            $addConfig = array(
                'block'                 => 0,
                'mode'                  => 'already',
                'class_name'            => 'ai_block_'.($block+1),
                'user_content'          =>'',
                'system_content_flag'   => 0,
                'system_content'        =>'',
                'max_tokens_flag'       => 0,
                'max_tokens'            => 2048,
                'temperature_flag'      => 0,
                'temperature'           => 1,
                'top_p_flag'            => 0,
                'top_p'                 => 0.9,
                'n_flag'                => 0,
                'n'                     => 1
            );
            $config[] = $addConfig;
            update_option('kworks_ai_config', $config);

            $config_generated = get_option('kworks_ai_config_generated');
            $html = kworks_ai_config_block_make_html($block, $config, $config_generated);

            $result = array(
                'status' => 'success',
                'message' => $html,
                'response' => []
            );

            wp_send_json( $result );
            return;

        case "delete":
            $block = isset($_POST['block']) ? (int)$_POST['block'] : 0;
            if($block && array_key_exists($block-1, $config)) {
                unset($config[$block-1]);
                update_option('kworks_ai_config', $config);
            }
            $result = array(
                'status' => 'success',
                'message' => 'Deletion of block '.$block.' is complete.',
                'response' => []
            );

            wp_send_json( $result );
            return;

        case "delete_all":
            update_option('kworks_ai_config', Array());

            $result = array(
                'status' => 'success',
                'message' => 'Deletion of all blocks is complete.',
                'response' => []
            );

            wp_send_json( $result );
            return;

        case "delete_all_and_generated" :
            update_option('kworks_ai_config', Array());
            update_option('kworks_ai_config_generated', Array());

            $result = array(
                'status' => 'success',
                'message' => 'Deletion of all blocks & all generated is complete.',
                'response' => []
            );

            wp_send_json( $result );
            return;

        default:
            break;
    }
    $test = isset($_POST['test']) ? (int)$_POST['test'] : 0;

    if($test==1) {
        $arg = $_POST;
    }
    else{
        $arg = array_merge($_POST, $api);
    }
    $block = isset($_POST['block']) ? (int)$_POST['block'] : 0;
    if(!$test && ($block <= 0 || $block > $configCount)) {

        $result = array(
            'status' => 'success',
            'message' => 'Access Denied.',
            'response' => []
        );
        wp_send_json( $result );
        return;
    }
    if($block) {

        $i = $block-1;

        $arg['user_content']    = isset($config[$i]['user_content']) ?   $config[$i]['user_content'] : "";

        $system_content_flag    = isset($config[$i]['system_content_flag']) ? (int)$config[$i]['system_content_flag'] : 0;
        $max_tokens_flag        = isset($config[$i]['max_tokens_flag']) ?     (int)$config[$i]['max_tokens_flag'] : 0;
        $temperature_flag       = isset($config[$i]['temperature_flag']) ?    (int)$config[$i]['temperature_flag'] : 0;
        $top_p_flag             = isset($config[$i]['top_p_flag']) ?          (int)$config[$i]['top_p_flag'] : 0;
        $n_flag                 = isset($config[$i]['n_flag']) ?              (int)$config[$i]['n_flag'] : 0;

        $arg['system_content']  = isset($config[$i]['system_content']) && $system_content_flag ? $config[$i]['system_content'] : "";
        $arg['max_tokens']      = isset($config[$i]['max_tokens']) && $max_tokens_flag ?         (int)$config[$i]['max_tokens'] : "";
        $arg['temperature']     = isset($config[$i]['temperature']) && $temperature_flag ?       (float)$config[$i]['temperature'] : "";
        $arg['top_p']           = isset($config[$i]['top_p']) && $top_p_flag ?                   (float)$config[$i]['top_p'] : "";
        $arg['n']               = isset($config[$i]['n']) && $n_flag ?                           (float)$config[$i]['n'] : "";
        $mode = isset($config[$i]['mode']) ? $config[$i]['mode'] : "real";
        if($mode == 'already') {

            $config_generated = get_option('kworks_ai_config_generated');
            $message = isset($config_generated[$i][0]) ? $config_generated[$i][0] : "";

            $result = array(
                'status' => 'success',
                'message' => $message,
                'response' => []
            );

            wp_send_json( $result );

            return;
        }

    }

    $result = getChatGPT($arg);
    wp_send_json( $result );

}
function getChatGPT($arg) {
    $api_key        = isset($arg['api_key']) ? $arg['api_key'] : '';
    $api_url        = isset($arg['endpoint']) ? $arg['endpoint'] : 'https://api.openai.com/v1/chat/completions';
    $model          = isset($arg['model']) ? $arg['model'] : 'gpt-3.5-turbo';
    $org_id         = isset($arg['org_id']) ? $arg['org_id'] : '';
    $user_content   = isset($arg['user_content']) ? $arg['user_content'] : "";

    $system_content = isset($arg['system_content']) ? $arg['system_content'] : "";
    $temperature    = isset($arg['temperature']) ? (float)$arg['temperature'] : "";
    $top_p          = isset($arg['top_p']) ? (float)$arg['top_p'] : "";
    $n              = isset($arg['n']) ? (float)$arg['n'] : "";
    $max_tokens     = isset($arg['max_tokens']) ? (int)$arg['max_tokens'] : "";

    $headers = [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $api_key
    ];
    if(!empty($org_id)) {
        $headers[] = 'OpenAI-Organization: ' . $org_id;
    }

    $data = [
        'model'         => $model,
        'stop'          => null,
        'messages' => [
            [
                'role' => 'user',
                'content' => $user_content
            ]
        ]
    ];

    if($system_content) {
        $data['messages'][] = [
            'role' => 'system',
            'content' => $system_content
        ];
    }
    if($temperature) { $data['temperature'] = $temperature; };
    if($top_p) { $data['top_p'] = $top_p; };
    if($n) { $data['n'] = $n; };
    if($max_tokens) { $data['max_tokens'] = $max_tokens; };

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data, JSON_UNESCAPED_UNICODE));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);

    $generated_text = "";

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    } else {
        $response = json_decode($response, true);

        if( (isset($response['error']) && is_array($response['error'])) ||
            (isset($response['choices']) && !is_array($response['choices'])) ) {

            $status = $response['error']['type'];

        } else {

            $status = 'success';
            $generated_text = $response['choices'][0]['message']['content'];

        }
    }
    curl_close($ch);

    $result = array(
        'status' => $status,
        'message' => $generated_text,
        'response' => $response
    );

    return $result;
}

function kworks_ai_getpost($postid) {

    $post_id = $postid;

    $args = array(
        'p' => $post_id,
        'post_type' => 'post',
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();

            $post_date = get_the_date('Y年m月d日');
            $post_title = get_the_title();
            $post_content = get_the_content();
        }
    }

    wp_reset_postdata();
    return $post = [
        'date'=>$post_date,
        'title'=>$post_title,
        'content'=>$post_content
    ];

}

function kworks_ai_add_menu() {
    add_submenu_page(
        'tools.php',
        'k.works AI',
        'k.works AI',
        'manage_options',
        'kworks-ai-settings',
        'kworks_ai_render_settings_page'
    );
}
add_action('admin_menu', 'kworks_ai_add_menu');

function kworks_ai_add_settings_sections() {
    add_settings_section(
        'kworks_ai_general_section',
        'General Settings',
        'kworks_ai_general_section_callback',
        'kworks_ai_settings'
    );
    add_settings_field(
        'kworks_ai_api',
        __('API Settings', 'kworks-ai'),
        'kworks_ai_api_callback',
        'kworks_ai_settings',
        'kworks_ai_general_section',
        array('class' => 'apis')
    );
    add_settings_field(
        'kworks_ai_toolbar',
        __('Tools', 'kworks-ai'),
        'kworks_ai_toolbar_callback',
        'kworks_ai_settings',
        'kworks_ai_general_section'
    );
    add_settings_field(
        'kworks_ai_config',
        __('Blocks', 'kworks-ai'),
        'kworks_ai_config_callback',
        'kworks_ai_settings',
        'kworks_ai_general_section'
    );

    register_setting(
        'kworks_ai_settings',
        'kworks_ai_api'
    );
    register_setting(
        'kworks_ai_settings',
        'kworks_ai_toolbar'
    );
    register_setting(
        'kworks_ai_settings',
        'kworks_ai_config'
    );
    register_setting(
        'kworks_ai_settings',
        'kworks_ai_config_generated'
    );

}
add_action('admin_init', 'kworks_ai_add_settings_sections');
register_uninstall_hook( __FILE__, 'kworks_ai_uninstall' );
function kworks_ai_uninstall() {
    if ( false !== get_option( 'kworks_ai_api' ) ) {
        unregister_setting( 'kworks_ai_settings', 'kworks_ai_api' );
        delete_option( 'kworks_ai_api' );
    }
    if ( false !== get_option( 'kworks_ai_toolbar' ) ) {
        unregister_setting( 'kworks_ai_settings', 'kworks_ai_toolbar' );
        delete_option( 'kworks_ai_toolbar' );
    }
    if ( false !== get_option( 'kworks_ai_config' ) ) {
        unregister_setting( 'kworks_ai_settings', 'kworks_ai_config' );
        delete_option( 'kworks_ai_config' );
    }
    if ( false !== get_option( 'kworks_ai_config_generated' ) ) {
        unregister_setting( 'kworks_ai_settings', 'kworks_ai_config_generated' );
        delete_option( 'kworks_ai_config_generated' );
    }

}
function kworks_ai_general_section_callback() {

    $api = get_option('kworks_ai_api');
    $value = isset($api['connection']) ? esc_attr($api['connection']) : "0";
    if(!$value) {
        $html = __('Enter your ChatGPT API information below.', 'kworks-ai');
    } else {
        $html = __('Please configure the settings for each block.', 'kworks-ai');
        $config = get_option('kworks_ai_config');
        if(!is_array($config) || !count($config)) {
            $html .= __('<br />If there are no blocks, click "Add Block".', 'kworks-ai');
        }
    }

    echo $html;
}
function kworks_ai_api_callback($args) {

    $api = get_option('kworks_ai_api');

    $html = '';
    $html .= '<div id="kworks_ai_api">';
    $html .= '<h3 data-block="1">API</h3>';
    $html .= '<div class="block-parent">';
    $html .= '<div class="block">';

    $value = isset($api['api_key']) ? esc_attr($api['api_key']) : '';

    $html .= '<div class="block_title">'.__('API Key | Organization ID', 'kworks-ai').'</div>
        <div><input type="text" name="kworks_ai_api[api_key]" title="" placeholder="sk-...xxxx" value="' . $value . '" />';

    $value = isset($api['org_id']) ? esc_attr($api['org_id']) : '';
    $html .= '<input type="text" name="kworks_ai_api[org_id]" title="" placeholder="org-...xxxx" value="' . $value . '" />';
    $html .= '</div>';

    $value = isset($api['model']) ? esc_attr($api['model']) : 'gpt-3.5-turbo';
    $html .= '<div class="block_title">'.__('Model', 'kworks-ai').'</div>
        <div><input type="text" name="kworks_ai_api[model]" title="" value="' . $value . '" /></div>
        ';

    $value = isset($api['endpoint']) ? esc_attr($api['endpoint']) : 'https://api.openai.com/v1/chat/completions';
    $html .= '<div class="block_title">'.__('Endpoint', 'kworks-ai').'</div>
          <div><input type="text" name="kworks_ai_api[endpoint]" title="" value="' . $value . '" /></div>
        ';
    $html .= '<div class="block_title">'.__('Test the connection.', 'kworks-ai').'</div>
          <div><textarea name="kworks_ai_config_generate_connection" readonly></textarea></div>
          <button class="button" name="kworks_ai_config_generate_connection">'.__('Connection', 'kworks-ai').'</button>
        ';
    $value = isset($api['connection']) ? esc_attr($api['connection']) : "0";
    $html .= '<input type="hidden" name="kworks_ai_api[connection]" value="'.$value.'"/>';
    $html .= '<span type="text" name="kworks_ai_config_generate_connection_guidance"  value=""></span>';

    $html .= '</div></div></div>';

    echo $html;

}
function kworks_ai_toolbar_callback() {

    $api = get_option('kworks_ai_api');
    $value = isset($api['connection']) ? esc_attr($api['connection']) : "0";
    $disabled = $value ? '' : 'disabled';

    $html = '';
    $html .= '<div id="kworks_ai_toolbar">';
    $html .= '<div class="block-parent">';
    $html .= '<div class="block">';
    $html .= '<button class="button block_add" '.$disabled.'>'.__('Add Block', 'kworks-ai').'</button>';
    $html .= '<button class="button expand_collapse" data-state="0" '.$disabled.'>'.__('Expand Blocks', 'kworks-ai').'</button>';
    $html .= '<button class="button blocks_delete" '.$disabled.'>'.__('Delete All Blocks', 'kworks-ai').'</button>';
    $html .= '</div</div></div>';

    echo $html;
}
function kworks_ai_config_callback() {

    $config = get_option('kworks_ai_config');
    $config_generated = get_option('kworks_ai_config_generated');

    $html = '<div id="kworks_ai_config" class="">';
    if(is_array($config)) {
        $html .= kworks_ai_config_block_make_html_all($config, $config_generated);
    }
    $html .= '</div>';

    echo $html;

}
function kworks_ai_config_block_make_html_all($config, $config_generated){

    $len = count($config);
    $keys = array_keys($config);

    $html = "";

    for ($i = 0; $i < $len; $i++) {
        $html .= kworks_ai_config_block_make_html($keys[$i], $config, $config_generated);
    }

    return $html;

}
function kworks_ai_config_block_make_html($i, $config, $config_generated){

    $html = "";

    $block = isset($config[$i]['block']) ? $config[$i]['block'] : '0';
    $blockOnOff = ($block == '1') ? 'On' : 'Off';
    $mode = isset($config[$i]['mode']) ? $config[$i]['mode'] :'already';
    $modeFlag = ($mode == 'real') ? '1' : '0';

    $class_name = isset($config[$i]['class_name']) ? esc_attr($config[$i]['class_name']) : 'ai_block_'.($i+1);
    $html .= '<h3 data-block="'.($i+1).'">'.
        '<span class="block_header">Block '.($i+1).'</span>'.
        '<span class="block_header_block_'.$block.'">'.$blockOnOff.'</span>'.
        '<span class="block_header_mode_'.$modeFlag.'">'.ucfirst($mode).'</span>'.
        '<span class="block_header_class_name">'.$class_name.'</span>'.
        '</h3>';

    $html .= '<div class="block-parent">';
    $html .= '<div class="block">';
    $value = isset($config[$i]['block']) ? $config[$i]['block'] : 0;
    $checkedOn = $value == '1' ? 'checked' : "";
    $checkedOff = $value == '0' ? 'checked' : "";

    $html .= '<div class="block_row right"><div class="block_action dashicons dashicons-trash"></div></div>';
    $html .= '<div class="block_title">'.__('Block', 'kworks-ai').' - On / Off<span class="dashicons dashicons-editor-help kworks_ai_config__block" title=""></span></div>';
    $html .= '<div class="kworks_ai_config_radio">
          <input type="radio" name="kworks_ai_config['.$i.'][block]" id="kworks_ai_config_block_on_'.$i.'" '.$checkedOn.' value="1">
            <label for="kworks_ai_config_block_on_'.$i.'">On</label>
          <input type="radio" name="kworks_ai_config['.$i.'][block]" id="kworks_ai_config_block_off_'.$i.'" '.$checkedOff.' value="0">
            <label for="kworks_ai_config_block_off_'.$i.'">Off</label>
        </div>';
    $value = isset($config[$i]['mode']) ? $config[$i]['mode'] : 'real';
    $checkedReal = $value == 'real' ? 'checked' : "";
    $checkedAlready = $value == 'already' ? 'checked' : "";

    $html .= '<div class="block_title">'.__('Mode', 'kworks-ai').'<span class="dashicons dashicons-editor-help kworks_ai_config__mode" title=""></span></div>';
    $html .= '<div class="kworks_ai_config_radio">
          <input type="radio" name="kworks_ai_config['.$i.'][mode]" id="kworks_ai_config_mode_real_'.$i.'" '.$checkedReal.' value="real">
            <label for="kworks_ai_config_mode_real_'.$i.'">Real</label>
          <input type="radio" name="kworks_ai_config['.$i.'][mode]" id="kworks_ai_config_mode_already_'.$i.'" '.$checkedAlready.' value="already">
            <label for="kworks_ai_config_mode_already_'.$i.'">Already</label>
        </div>
        ';
    $class_name_html = '<div class="' . $class_name . '"></div>';
    $html .= '<div class="block_title">'.__('Class Name', 'kworks-ai').'<span class="dashicons dashicons-editor-help kworks_ai_config__class_name" title=""></span></div>';
    $html .= '<div class="block_field">';
    $html .= '<input type="text" class="edit_field" name="kworks_ai_config['.$i.'][class_name]" onclick="kworks.ADMIN.copy(this);" readonly title="" value="' . $class_name . '" />';
    $html .= '<div class="edit_button">
            <button class="button edit" name="kworks_ai_config['.$i.'][class_name]">'.__('Edit', 'kworks-ai').'</button>
            <button class="button apply" name="kworks_ai_config['.$i.'][class_name]" disabled>'.__('Apply', 'kworks-ai').'</button>
            </div>';
    $html .= '<span class="html_field" name="kworks_ai_config['.$i.'][class_name]" onclick="kworks.ADMIN.copy(this);" title="">' . esc_attr($class_name_html) . '</span>';
    $html .= '</div>';
    $value = isset($config[$i]['user_content']) ? esc_textarea($config[$i]['user_content']) : '';
    $disabled = $value ? '' : 'disabled';
    $html .= '<div class="block_title">'.__('Message (User role)', 'kworks-ai').'<span class="dashicons dashicons-editor-help kworks_ai_config__user_content" title=""></span></div>
        <div><textarea name="kworks_ai_config['.$i.'][user_content]" class="'.($mode=='real' ? "ka_mode_real":"").'" value="" title="">'.$value.'</textarea></div>
        <div><button class="button" name="kworks_ai_config_generated['.$i.'][0]" '.$disabled.'>'.__('Generate', 'kworks-ai').'</button></div>
        ';
    $value = isset($config_generated[$i][0]) ? esc_textarea($config_generated[$i][0]) : '';
    $value = stripcslashes($value);

    $html .= '<div class="block_title">'.__('Generated', 'kworks-ai').'<span class="dashicons dashicons-editor-help kworks_ai_config__generated" title=""></span></div>';
    $html .= '<div><input type="hidden" name="kworks_ai_config_generated['.$i.'][0]" value="'.$value.'">
        <textarea name="kworks_ai_config_generated['.$i.'][0]" readonly class="edit_field ka_mode_'.$mode.'" value="">'.$value.'</textarea>';
    $html .= '<div class="edit_button">
        <button class="button edit" name="kworks_ai_config_generated['.$i.'][0]">'.__('Edit', 'kworks-ai').'</button>
        <button class="button apply" name="kworks_ai_config_generated['.$i.'][0]" disabled>'.__('Apply', 'kworks-ai').'</button>
        </div>';
    $html .= '</div>';
    $html .= '<div class="block_details accordion_inner">';
    $html .= '<h4>Details (Block '.($i+1).')</h4>';
    $html .= '<div>';
    $value = isset($config[$i]['system_content']) ? esc_attr($config[$i]['system_content']) : '';
    $html .= '<div class="block_title">'.__('Message (System role)', 'kworks-ai').'<span class="dashicons dashicons-editor-help kworks_ai_config__system_content" title=""></span></div>';
    $html .= '<div>'.kworks_ai_config_make_flag($config,'system_content',$i);
    $html .= '<textarea name="kworks_ai_config['.$i.'][system_content]" value="" title="" readonly>'.$value.'</textarea>';
    $html .= '<button class="button" name="kworks_ai_config['.$i.'][system_content]">'.__('Clear', 'kworks-ai').'</button>';
    $html .= '</div>';
    $value = isset($config[$i]['max_tokens']) ? esc_attr($config[$i]['max_tokens']) : '2048';
    $html .= '<div class="block_title">'.__('max_tokens (Defaults to infinity)', 'kworks-ai').'<span class="dashicons dashicons-editor-help kworks_ai_config__max_tokens" title=""></span></div>';
    $html .= '<div>'.kworks_ai_config_make_flag($config,'max_tokens',$i);
    $html .= '<span id="kworks_ai_config['.$i.'][max_tokens]">'.$value.'</span><input type="range" name="kworks_ai_config['.$i.'][max_tokens]" min="1" max="4096" step="1" title="" value="' . $value . '" />';
    $html .= '</div>';
    $value = isset($config[$i]['temperature']) ? esc_attr($config[$i]['temperature']) : '1';
    $html .= '<div class="block_title">'.__('temperature (Defaults to 1)', 'kworks-ai').'<span class="dashicons dashicons-editor-help kworks_ai_config__temperature" title=""></span></div>';
    $html .= '<div>'.kworks_ai_config_make_flag($config,'temperature',$i);
    $html .= '<span id="kworks_ai_config['.$i.'][temperature]">'.$value.'</span><input type="range" name="kworks_ai_config['.$i.'][temperature]" min="0" max="2" step="0.1" title="" value="' . $value . '" />';
    $html .= '</div>';
    $value = isset($config[$i]['top_p']) ? esc_attr($config[$i]['top_p']) : '0.9';
    $html .= '<div class="block_title">'.__('top_p (Defaults to 1)', 'kworks-ai').'<span class="dashicons dashicons-editor-help kworks_ai_config__top_p" title=""></span></div>';
    $html .= '<div>'.kworks_ai_config_make_flag($config,'top_p',$i);
    $html .= '<span id="kworks_ai_config['.$i.'][top_p]">'.$value.'</span><input type="range" name="kworks_ai_config['.$i.'][top_p]" min="0" max="1" step="0.1" title="" value="' . $value . '" />';
    $html .= '</div>';
    $value = isset($config[$i]['n']) ? esc_attr($config[$i]['n']) : '1';
    $html .= '<div class="block_title">'.__('n (Defaults to 1) ', 'kworks-ai').'<span class="dashicons dashicons-editor-help kworks_ai_config__n" title=""></span></div>';
    $html .= '<div>'.kworks_ai_config_make_flag($config,'n',$i);
    $html .= '<span id="kworks_ai_config['.$i.'][n]">'.$value.'</span><input type="range" name="kworks_ai_config['.$i.'][n]" min="1" max="10" step="1" title="" value="' . $value . '" />';
    $html .= '</div>';

    $html .= '</div></div>';

    $html .= '</div></div>';

    return $html;
}
function kworks_ai_config_make_flag($config, $param, $i) {

    $value = isset($config[0][$param.'_flag']) ? $config[0][$param.'_flag'] : '0';
    $on = $value == '1' ? 'checked' : "";
    $off = $value == '0' ? 'checked' : "";
    $id_for = 'kworks_ai_config_'.$param.'_flag';
    $flag= '<div class="kworks_ai_config_radio_flag">
          <input type="radio" name="kworks_ai_config['.$i.']['.$param.'_flag]" id="'.$id_for.'_on_'.$i.'" '.$on.' value="1">
            <label for="'.$id_for.'_on_'.$i.'">On</label>
          <input type="radio" name="kworks_ai_config['.$i.']['.$param.'_flag]" id="'.$id_for.'_off_'.$i.'" '.$off.' value="0">
            <label for="'.$id_for.'_off_'.$i.'">Off</label>
        </div>
        ';

    return $flag;
}

function kworks_ai_render_settings_page() {
    add_settings_error(
        'kworks_ai_options',
        'kworks_ai_api_key_saved',
        __('Saved.', 'kworks-ai'),
        'updated'
    );
    if (isset($_POST['submit'])) {
        settings_errors('kworks_ai_options');
    }
    ?>
    <div class="wrap">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
        <form method="post" action="">
            <?php settings_fields('kworks_ai_config'); ?>
            <?php do_settings_sections('kworks_ai_settings'); ?>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

function kworks_ai_save_options() {

    if (isset($_POST['kworks_ai_api'])) {
        update_option('kworks_ai_api', $_POST['kworks_ai_api']);
    }
    if (isset($_POST['kworks_ai_config'])) {
        update_option('kworks_ai_config', $_POST['kworks_ai_config']);
    }
    if (isset($_POST['kworks_ai_config_generated'])) {
        update_option('kworks_ai_config_generated', $_POST['kworks_ai_config_generated']);
    }

}
add_action('admin_init', 'kworks_ai_save_options');
function kworks_ai_add_tools_link($links) {
    $tools_link = '<a href="' . admin_url('tools.php?page=kworks-ai-settings') . '">' . __('Settings', 'kworks-ai') . '</a>';
    array_push($links, $tools_link);
    return $links;
}
$plugin_basename = plugin_basename(__FILE__);
add_filter("plugin_action_links_$plugin_basename", 'kworks_ai_add_tools_link');

add_action( 'admin_ajax_kworks_ai_ajax_function', 'kworks_ai_ajax_function' );

add_action( 'wp_ajax_kworks_ai_ajax_function_init', 'kworks_ai_ajax_function_init' );
add_action( 'wp_ajax_nopriv_kworks_ai_ajax_function_init', 'kworks_ai_ajax_function_init' );
add_action( 'wp_ajax_kworks_ai_ajax_function', 'kworks_ai_ajax_function' );
add_action( 'wp_ajax_nopriv_kworks_ai_ajax_function', 'kworks_ai_ajax_function' );
